####################################################################### 
# R code: Exercise 2.9
# File: R-script-AR-NN.r
#
# Estimating and forecasting AR-NN(k;p,...,p) models
# with p = 7 and 8, and k = 0,1,...,5 (number of hidden units).
#
# Note: The results need not be exactly
#       as shown in the main text since they depend heavily on the
#       initial weights chosen by random in the R-function nnet.
#######################################################################
library(nnet)

# load the data into workspace
eeg <- read.table("c:\\...\\eeg.dat")
mod <- list()
# Last H = 80 observations are used for forecasting
hor <- 80
set.seed(1)

n    <- length (eeg[,1])
nhor <- n-hor
n1   <- n-1-hor
n2   <- n-2-hor
n3   <- n-3-hor
n4   <- n-4-hor
n5   <- n-5-hor
n6   <- n-6-hor
n7   <- n-7-hor
n8   <- n-8-hor

for (p in (7:8)){
   pp <- p+1

#  Range of initial random weights [-rang1,rang1]
   rang1 <- 1/max(eeg)
   y     <- eeg[pp:nhor,1]

#  Obtain the input variables eeg(t-1),...,eeg(t-p))
   if (p == 7){
     nr <- n7
     p1 <- p-1
     p2 <- p-2
     p3 <- p-3
     p4 <- p-4
     p5 <- p-5
     p6 <- p-6
     eeg.x <- cbind(eeg[p:n1,1],eeg[p1:n2,1],eeg[p2:n3,1],eeg[p3:n4,1],
                    eeg[p4:n5,1],eeg[p5:n6,1],eeg[p6:n7,1])
     }
   if (p == 8){
     nr <- n8
     p1 <- p-1
     p2 <- p-2
     p3 <- p-3
     p4 <- p-4
     p5 <- p-5
     p6 <- p-6
     p7 <- p-7
     eeg.x <- cbind(eeg[p:n1,1],eeg[p1:n2,1],eeg[p2:n3,1],eeg[p3:n4,1],
                    eeg[p4:n5,1],eeg[p5:n6,1],eeg[p6:n7,1],eeg[p7:n8,1])
     }

     for (k in (0:5)){
#       Build a p-k-1 network with skip layer connections and linear inputs
        eeg.nn <- nnet(eeg.x,y,size=k,linout=T,skip=T,maxit=10000,decay=1e-2,
                       reltol=1e-7,abstol=1e-7,rang=rang1)  
        npar <- p+1+k*(p+2)

#       Sum of squared residuals
        sse <- sum((y-predict(eeg.nn,eeg.x))^2)

#       Estimate of the residual variance
        resvar <- sse/nr

#       AIC and SBIC
        aic <- nr*log(sse) + 2*npar
        bic <- nr*log(sse) + npar*log(nr)

#       Setup the input variables in the forecasting subsample
        if (p ==  7){
        eeg.p <- cbind(eeg[551:630,1],eeg[550:629,1],eeg[549:628,1],
                 eeg[548:627,1],eeg[547:626,1],eeg[546:625,1],eeg[545:624,1])
        }
        if (p == 8){
        eeg.p <- cbind(eeg[551:630,1],eeg[550:629,1],eeg[549:628,1],
                 eeg[548:627,1],eeg[547:626,1],eeg[546:625,1],eeg[545:624,1],
                 eeg[544:623,1])
        }
#       Compute the forecasts
        yh <- predict(eeg.nn,eeg.p) 
#       The observed values the forecasting subsample
        yo <- eeg[552:n,1]           
#       Compute and print the sum of squares of forecast errors
        ssfe    <- sum((yo-yh)^2)
        rootmse <- sqrt(ssfe/80)
        mae     <- sum(abs(yo-yh))/80
#       Print summary results 
        stats   <- cbind(p,k,npar,resvar,aic,bic,rootmse,mae)
        print(stats)
     }  # end loop for k 
}       # end loop for p

